<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/sdrfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:ns3="http://www.sec.gov/edgar/sdrcommon">

	<!-- Item 4 templates -->
	<xsl:template name="Item4">
		<h3>
			<em>Custodian Information
			</em>
		</h3>
		<xsl:call-template name="custodianInfo" />
	</xsl:template>

	<xsl:template name="custodianInfo">
		<xsl:for-each select="m1:custodianInfo/m1:custodian">
			<table role="presentation" >
				<tr>
					<td class="label">Name of Person:
					</td>
					<td>
						<p>
							<div align="left">
								<div class="fakeBox3">
									<xsl:value-of select="m1:nameInfo/m1:name" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">
						Request Confidentiality:
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="m1:nameInfo/m1:nameConfFlag = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<td class="label">Telephone Number:
					</td>
					<td>
						<p>
							<div align="left">
								<div class="fakeBox2">
									<xsl:value-of
										select="m1:phoneInfo/m1:phone" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">
						Request Confidentiality:
					</td>
					<td>
						<xsl:choose>
							<xsl:when
								test="m1:phoneInfo/m1:phoneConfFlag = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
				<tr>
					<h4>
						<em>Address Infomation:</em>
					</h4>
				</tr>
				<tr>
					<td class="label">Address 1 Street 1 </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of select="m1:addressInfo/m1:addressOneStreet1" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Address 1 Street 2 </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of select="m1:addressInfo/m1:addressOneStreet2" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Address 1 City </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:value-of select="m1:addressInfo/m1:addressOneCity" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Address 1 State/Country </td>
					<td>
						<p>
							<div class="fakeBox">
								<xsl:call-template name="stateDescription">
									<xsl:with-param name="stateCode"
										select="string(./m1:addressInfo/m1:addressOneStateCountry)" />
								</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Address 1 Mailing Zip/ Postal Code </td>
					<td>
						<p>
							<div class="fakeBox2">
								<xsl:value-of select="m1:addressInfo/m1:addressOneZipCode" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">
						Request Confidentiality:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="(m1:addressInfo/m1:addressOneConfFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</table>
			<table role="presentation" >
				<tr>
					<td class="label">
						Different Address:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="(m1:addressInfo/m1:diffrentAddressFlag) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</table>
			<xsl:if test="(m1:addressInfo/m1:diffrentAddressFlag) = 'true'">
				<table role="presentation" >
					<tr>
						<td class="label">Address 2 Street 1 </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of select="m1:addressInfo/m1:addressTwoStreet1" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Address 2 Street 2 </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of select="m1:addressInfo/m1:addressTwoStreet2" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Address 2 City </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:value-of select="m1:addressInfo/m1:addressTwoCity" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Address 2 State/Country </td>
						<td>
							<p>
								<div class="fakeBox">
									<xsl:call-template name="stateDescription">
										<xsl:with-param name="stateCode"
											select="string(./m1:addressInfo/m1:addressTwoStateCountry)" />
									</xsl:call-template>
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">Address 2 Mailing Zip/ Postal Code </td>
						<td>
							<p>
								<div class="fakeBox2">
									<xsl:value-of select="m1:addressInfo/m1:addressTwoZipCode" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</p>
						</td>
					</tr>
					<tr>
						<td class="label">
							Request Confidentiality:
						</td>
						<td>
							<xsl:choose>
								<xsl:when test="(m1:addressInfo/m1:addressTwoConfFlag) = 'true'">
									<img src="Images/box-checked.jpg" alt="Checkbox checked" />
								</xsl:when>
								<xsl:otherwise>
									<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
								</xsl:otherwise>
							</xsl:choose>
						</td>
					</tr>
				</table>
			</xsl:if>
		</xsl:for-each>


	</xsl:template>
</xsl:stylesheet>